using System;
using System.Globalization;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        double[] x = new double[n];
        double[] h = new double[n];

        string[] xs = Console.ReadLine().Split();
        string[] hs = Console.ReadLine().Split();

        for (int i = 0; i < n; i++) x[i] = double.Parse(xs[i], CultureInfo.InvariantCulture);
        for (int i = 0; i < n; i++) h[i] = double.Parse(hs[i], CultureInfo.InvariantCulture);

        for (int i = 0; i < n; i++)
        {
            double best = 1e18;

            for (int j = 0; j < n; j++)
            {
                if (h[j] >= h[i])
                {
                    double dx = x[j] - x[i];
                    double dy = h[j] - h[i];
                    double d = Math.Sqrt(dx * dx + dy * dy);
                    if (d < best) best = d;
                }
            }

            for (int j = 0; j + 1 < n; j++)
            {
                double x1 = x[j], h1 = h[j];
                double x2 = x[j + 1], h2 = h[j + 1];

                double xm = ((x1 + h1) + (x2 - h2)) / 2.0;

                if (h1 >= h[i])
                {
                    double xl = x1;
                    double xr = Math.Min(xm, x1 + (h1 - h[i]));
                    if (xl <= xr)
                    {
                        double xc = Math.Min(Math.Max(x[i], xl), xr);
                        double d = Math.Abs(xc - x[i]);
                        if (d < best) best = d;
                    }
                }

                if (h2 >= h[i])
                {
                    double xl = Math.Max(xm, x2 - (h2 - h[i]));
                    double xr = x2;
                    if (xl <= xr)
                    {
                        double xc = Math.Min(Math.Max(x[i], xl), xr);
                        double d = Math.Abs(xc - x[i]);
                        if (d < best) best = d;
                    }
                }
            }

            if (best > 5e17)
                Console.WriteLine("-1");
            else
            {
                if (Math.Abs(best - Math.Round(best)) < 1e-9)
                    Console.WriteLine((long)Math.Round(best));
                else
                    Console.WriteLine(best.ToString(CultureInfo.InvariantCulture));
            }
        }
    }
}